@props([
    'method' => 'DELETE',
])
<script>
    $(document).ready(function() {
        $(document).on('click', '.confirm-me', function() {
            var url = $(this).attr('data-url');
            var token = $('meta[name="csrf-token"]').attr('content');
            cuteAlert({
                type: "question",
                title: "Are you sure?",
                message: "You won't be able to revert this!",
                confirmText: "Yes, Continue!",
                cancelText: "Cancel",
            }).then((e) => {
                if (e == ("confirm")) {
                    $.ajax({
                        url: url,
                        type: '{{$method}}',
                        data: {
                            _token: token
                        },
                        success: (response) => {
                            if (response.status == 'success') {
                                cuteToast({
                                    type: "success",
                                    message: response.message,
                                    timer: 5000
                                })
                                setTimeout(function() {
                                    location.reload();
                                }, 1000);
                            } else {
                                cuteToast({
                                    type: "error",
                                    message: response.message,
                                    timer: 5000
                                })
                            }
                        },
                        error: (error) => {
                            cuteToast({
                                type: "error",
                                message: error.responseJSON.message,
                                timer: 5000
                            })
                        }
                    });
                }
            })
        });
    });
</script>
